/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import oracle.install.commons.swing.Glasspane;
import oracle.install.commons.swing.HtmlPane;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.util.IconLibrary;
import oracle.install.commons.util.exception.ExceptionHandler;
import oracle.install.commons.util.exception.ExceptionManager;

public class StatusPane
extends JPanel {
    private static final String FMT_MESSAGE = "<html><body><table width=\"100%\" height=\"100%\"><tr><td align=\"center\" valign=\"middle\">{0}</td></tr></table></body></html>";
    private static String DEFAULT_ICON_PATH = "/oracle/install/commons/swing/resource/processing.gif";
    public static int PROGRESS_ICON = 1;
    public static final Dimension DEFAULT_MESSAGE_PANE_SIZE = new Dimension(350, 80);
    private JPanel messagePanel;
    private Dimension messagePaneSize = DEFAULT_MESSAGE_PANE_SIZE;
    private HtmlPane txtMessage;
    private JLabel lblIcon;
    private MessagePane layeredPane;
    private ImageIcon defaultIcon;

    public static StatusPane getInstance(JComponent component) {
        Glasspane glasspane = Glasspane.getInstance(component);
        StatusPane instance = (StatusPane)glasspane.getLayer(Glasspane.STATUS);
        if (instance == null) {
            instance = new StatusPane(glasspane);
            glasspane.addLayer(instance, Glasspane.STATUS);
        }
        return instance;
    }

    private StatusPane(Glasspane glasspane) {
        this.setOpaque(false);
        this.enableEvents(16L);
        ExceptionManager.getInstance().addExceptionHandler(Throwable.class, new StatusPaneExceptionHandler(this));
        this.buildUI(glasspane);
        this.defaultIcon = IconLibrary.getInstance().getIcon(DEFAULT_ICON_PATH);
    }

    protected void buildUI(Glasspane glasspane) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.messagePanel = new JPanel();
        this.messagePanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.lblIcon = new JLabel();
        this.txtMessage = new HtmlPane();
        this.txtMessage.setBorder(BorderFactory.createEmptyBorder());
        this.txtMessage.setOpaque(true);
        this.txtMessage.setBackground(this.messagePanel.getBackground());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                StatusPane.this.relocateMessagePanel(e.getComponent());
            }
        });
        JPanel pnlContent = new JPanel(new GridBagLayout());
        LayoutUtils.addComponent(this.lblIcon, pnlContent, 0, 0, 1, 1, 0, 13, 0.0, 0.0, new Insets(0, 0, 0, 0));
        LayoutUtils.addComponent(this.txtMessage, pnlContent, 1, 0, 1, 1, 2, 17, 1.0, 0.0, new Insets(0, 0, 0, 0));
        this.messagePanel.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(pnlContent, this.messagePanel, 0, 0, 1, 1, 1, 10, 1.0, 1.0);
        this.layeredPane = new MessagePane();
        this.layeredPane.add((Component)this.messagePanel, JLayeredPane.PALETTE_LAYER);
        this.add(this.layeredPane);
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void relocateMessagePanel(Component parent) {
        int x = parent.getWidth() / 2 - (int)this.messagePaneSize.getWidth() / 2 - 1;
        int y = parent.getHeight() / 2 - (int)this.messagePaneSize.getHeight() / 2 - 1;
        this.messagePanel.setBounds(x, y, this.messagePaneSize.width, this.messagePaneSize.height);
        this.messagePanel.setSize(this.messagePaneSize);
        this.messagePanel.setPreferredSize(this.messagePaneSize);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        e.consume();
    }

    public void showMessage(String message, int iconType) {
        if (iconType == PROGRESS_ICON) {
            this.showMessage(message, this.defaultIcon);
        }
    }

    public void showMessage(String message, Icon icon) {
        if (message != null) {
            this.txtMessage.setVisible(true);
            this.txtMessage.setText(MessageFormat.format(FMT_MESSAGE, message));
            if (icon != null) {
                this.lblIcon.setIcon(icon);
            }
            this.lblIcon.setVisible(icon != null);
        } else {
            this.txtMessage.setVisible(false);
            this.lblIcon.setVisible(false);
        }
        this.layeredPane.setVisible(this.txtMessage.isVisible() || this.lblIcon.isVisible());
        this.setVisible(true);
    }

    public void showMessage(String message) {
        this.showMessage(message, PROGRESS_ICON);
    }

    public static void showMessage(JComponent component, String message, int iconType) {
        StatusPane statusPane = StatusPane.getInstance(component);
        statusPane.showMessage(message, iconType);
    }

    public static void showMessage(JComponent component, String message, Icon icon) {
        StatusPane statusPane = StatusPane.getInstance(component);
        statusPane.showMessage(message, icon);
    }

    public static void showMessage(JComponent component, String message) {
        StatusPane statusPane = StatusPane.getInstance(component);
        statusPane.showMessage(message);
    }

    public static void hideMessage(JComponent component) {
        StatusPane statusPane = StatusPane.getInstance(component);
        statusPane.setVisible(false);
    }

    public Dimension getMessagePaneSize() {
        return this.messagePaneSize;
    }

    public void setMessagePaneSize(Dimension messagePaneSize) {
        this.messagePaneSize = messagePaneSize;
        this.relocateMessagePanel(this.getParent());
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
    }

    private class MessagePane
    extends JLayeredPane {
        private RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

        public MessagePane() {
            this.renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }

        private AlphaComposite makeComposite(float alpha) {
            int type = 3;
            return AlphaComposite.getInstance(type, alpha);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            Composite oldComposite = g2.getComposite();
            g2.setComposite(this.makeComposite(0.5f));
            Rectangle rect = this.getBounds();
            Color oldColor = g2.getColor();
            g2.setColor(Color.gray);
            g2.fillRect(rect.x, rect.y, rect.width, rect.height);
            g2.setComposite(oldComposite);
            g2.setColor(oldColor);
        }
    }

    private static class StatusPaneExceptionHandler
    implements ExceptionHandler<Throwable> {
        private StatusPane statusPane;

        public StatusPaneExceptionHandler(StatusPane statusPane) {
            this.statusPane = statusPane;
        }

        @Override
        public void handleException(Throwable exception) {
            this.statusPane.setVisible(false);
        }
    }
}

